require( "scripts/style.lua" );


UnlockableTitleFont = {
  standardFont,
  30,
  BorderColor
};

UnlockableTextFont = {
  standardFont,
  18,
  BorderColor
};




MakeDialog
{
	Bitmap
	{ 
		image="backgrounds/popup",
		x=kCenter,
		y=kCenter,
		
		Text
		{
			font = UnlockableTitleFont,
			x=0,y=35,w=kMax,h=30,
			flags = kHAlignCenter + kVAlignTop,
			label = 'entercode'
		};
		
		Bitmap
		{
			image="backgrounds/textfield.png",
			x=kCenter,
			y=95,
			
			TextEdit
			{
				font = UnlockableTextFont,
				name = "nameedit",
				label = startname,
				x=5,y=6,w=kMax-5,h=kMax,
				length=20,
				ignore = kIllegalNameChars
				
			};
		};
			
		SetStyle(StandardButtonStyle);
		Button
		{
			x=60,
			y=145,
			name="enterok",
			label="ok",
			default = true,
			
			command = 
				function()
					codeval = GetLabel("nameedit");
					
					if (codeval == "38423") then
						EnterUnlockable("movies");
						EnableWindow("movies", true);
						DisplayDialog { 
								"scripts/ok.lua", 
								body ="moviescode",
								title = ""
							};
					
					elseif (codeval == "78291") then
						EnterUnlockable("story");
						DisplayDialog { 
								"scripts/ok.lua", 
								body ="storycode",
								title = ""
							};
						SetDefaultGameSettings();
						PopModal("mainmenumodal");
						LaunchMapScreen(false);
						
					else
						DisplayDialog { 
								"scripts/ok.lua", 
								body ="invalidcode",
								title = ""
							};
						
					end
					SetFocus( "nameedit" );
				end
			
		},
		
		
		
		Button
		{
			x=245,
			y=145,
			name="entercancel",
			label="cancel",
			command = 
				function()
					PopModal("scripts/unlockables.lua");
				end
		};
		
		Button
		{
			x=kCenter,
			y=195,
			name="movies",
			label="movies",
			command = 
				function()
					PopModal("scripts/unlockables.lua");
					PopModal("scripts/options.lua");
					DoModal("scripts/movies.lua");
				end
		};
		
		
		SetStyle(DefaultStyle);
		
	},
	
	
}

SetFocus( "nameedit" );

if (not EnteredUnlockable("movies")) then
	EnableWindow("movies", false);
end



